# vim:set ft= ts=4 sw=4 et fdm=marker:
use Test::Nginx::Socket::Lua::Stream;

#worker_connections(1014);
#master_on();
#workers(2);
#log_level('warn');

repeat_each(2);

plan tests => repeat_each() * (blocks() * 2 + 4);

#no_diff();
no_long_string();
run_tests();

__DATA__

=== TEST 1: matched with d
--- stream_server_config
    content_by_lua_block {
        local m = ngx.re.match("hello", "(he|hell)", "d")
        if m then
            ngx.say(m[0])
        else
            ngx.say("not matched!")
        end
    }
--- stream_response
hell



=== TEST 2: matched with d + j
--- stream_server_config
    content_by_lua_block {
        local m = ngx.re.match("hello", "(he|hell)", "jd")
        if m then
            ngx.say(m[0])
        else
            ngx.say("not matched!")
        end
    }
--- stream_response
hell



=== TEST 3: not matched with j
--- stream_server_config
    content_by_lua_block {
        local m = ngx.re.match("world", "(he|hell)", "d")
        if m then
            ngx.say(m[0])
        else
            ngx.say("not matched!")
        end
    }
--- stream_response
not matched!



=== TEST 4: matched with do
--- stream_server_config
    content_by_lua_block {
        local m = ngx.re.match("hello", "he|hell", "do")
        if m then
            ngx.say(m[0])
            ngx.say(m[1])
            ngx.say(m[2])
        else
            ngx.say("not matched!")
        end
    }
--- stream_response
hell
nil
nil



=== TEST 5: not matched with do
--- stream_server_config
    content_by_lua_block {
        local m = ngx.re.match("world", "([0-9]+)", "do")
        if m then
            ngx.say(m[0])
        else
            ngx.say("not matched!")
        end
    }
--- stream_response
not matched!



=== TEST 6: UTF-8 mode without UTF-8 sequence checks
--- stream_server_config
    content_by_lua_block {
        local m = ngx.re.match("你好", ".", "Ud")
        if m then
            ngx.say(m[0])
        else
            ngx.say("not matched!")
        end
    }
--- stap
probe process("$LIBPCRE_PATH").function("pcre_compile") {
    printf("compile opts: %x\n", $options)
}

probe process("$LIBPCRE_PATH").function("pcre_dfa_exec") {
    printf("exec opts: %x\n", $options)
}

--- stap_out
compile opts: 800
exec opts: 2000

--- stream_response
你
--- no_error_log
[error]



=== TEST 7: UTF-8 mode with UTF-8 sequence checks
--- stream_server_config
    content_by_lua_block {
        local m = ngx.re.match("你好", ".", "ud")
        if m then
            ngx.say(m[0])
        else
            ngx.say("not matched!")
        end
    }
--- stap
probe process("$LIBPCRE_PATH").function("pcre_compile") {
    printf("compile opts: %x\n", $options)
}

probe process("$LIBPCRE_PATH").function("pcre_dfa_exec") {
    printf("exec opts: %x\n", $options)
}

--- stap_out
compile opts: 800
exec opts: 0

--- stream_response
你
--- no_error_log
[error]



=== TEST 8: matched dfa after nfa
--- stream_server_config
    content_by_lua_block {
        local m1 = ngx.re.match("hello", "(a)(a)(a)")
        if m1 then
            ngx.say(m1[0])
        else
            ngx.say("not matched!")
        end

        local m2 = ngx.re.match("world", "w", "d")
        if m2 then
            ngx.say(m2[0])
        else
            ngx.say("not matched!")
        end
    }
--- stream_response
not matched!
w
